import os
import sys
import subprocess
import numpy as np
from glob import glob
from shutil import copyfile
import time
from scripts.align_ply_from_ape_log import align_ply_from_ape_log
import socket

if __name__ == "__main__":
    hostname = socket.gethostname()
    IMU_poseinit_after = 25 
    stride = 1

    output_folder = f"/home/zihzhu/data/output_fastlivo/code_release_test4"
    config_file = "config/fastlivo.yaml"
    # traj_name = 'traj_kf.txt'
    # traj_name = 'traj_full_beforeBA.txt'
    traj_name = 'traj_kf_beforeBA.txt'
    # traj_name = 'traj_kf_afterBA.txt' 
    
    print(output_folder)
    if hostname == 'zihzhu':
        seqs = sorted(glob('/home/zihzhu/data/Datasets/fast-livo2-dataset/*'))
    else:
        seqs = sorted(glob('/cluster/project/cvg/zihzhu/Datasets/fast-livo2-dataset/*'))
    output_folder_type=output_folder.split('/')[-1]
    os.makedirs(os.path.join(output_folder, 'pcs'), exist_ok=True)
    print(seqs)
    excel=''
    excel_scale=''
    ate_values = []
    scale_errors = []
    for i, seq in enumerate(seqs[:]):
        if 'TimeStamps' in seq:
            continue
        if 'stride' in seq:
            continue
        if 'HIT_Graffiti_Wall_01' in seq:
            continue
        if 'Red_Sculpture' in seq:
            continue

        if 'pgt' in seq:
            continue
        name = os.path.basename(seq)
        
        os.makedirs(os.path.join(output_folder, name), exist_ok=True)
        print("##################################  Processing: {}  ##################################".format(seq))
        cmd = f'python demo.py --calib {seq}/intrinsics.txt  \
                --imagedir {seq}/rgb \
                --config {config_file} \
                --stride {stride} \
                --IMU_poseinit_after {IMU_poseinit_after} \
                --imufile {seq}/imu.txt --output {output_folder}/{name} \
                --undistort --start 0 > {output_folder}/{name}/log.txt' #--gsmapping
                # --final_ba_inertial \--gsmapping
        print(cmd)
        if (not os.path.exists(f'{output_folder}/{name}/{traj_name}')):
            gpu_mem=20
            time=4
            # print(cmd)
            os.system(cmd)
            # os.system(f"sbatch --time={time}:00:00 -A ls_polle -n 1  --cpus-per-task=8 --mem-per-cpu=7G  --gpus=1 --gres=gpumem:{gpu_mem}g --output=slurms/{output_folder_type}_{name}.out  --wrap '{cmd}'")
            # continue

        cmd = f'evo_ape tum -vas --no_warnings --plot_mode xy --save_plot {output_folder}/{name}/ape_se3.png --save_results {output_folder}/{name}/ape_results.zip \
            {seq}/../pgt/{name}.txt {output_folder}/{name}/{traj_name} > {output_folder}/{name}/log_ape_{traj_name}'
        if True or (not os.path.exists(f'{output_folder}/{name}/ape_se3_map.png')):
            os.system(cmd)

        try:
            ATE = float([l for l in open(f'{output_folder}/{name}/log_ape_{traj_name}').readlines() if 'rmse' in l][-1].split('\t')[-1])
            scale = float([l for l in open(f'{output_folder}/{name}/log_ape_{traj_name}').readlines() if 'Scale correction' in l][-1].split(' ')[-1])
            # print(f'APE before: {ATE:.4f}, scale: {scale:.4f}')
            ATE_cm = ATE * 100
            scale_err_percent = abs(1 - scale) * 100
            
            ate_values.append(ATE_cm)
            scale_errors.append(scale_err_percent)
            
            excel=excel+' ,'+str(ATE_cm)
            excel_scale=excel_scale+' ,'+str(scale_err_percent)
            print(f'APE before: {ATE:.4f}, scale: {scale:.4f}, Rel. scale error: {abs(1-scale):.4f}')
        except:
            excel=excel+' ,' + 'F'
            excel_scale=excel_scale+' ,' + 'NA'

        # get aligned 3dgs
        try:
            if True:
                if 'beforeBA' in traj_name:
                    before_align_3dgs = f'{output_folder}/{name}/3dgs_before_final.ply'
                    after_align_3dgs = f'{output_folder}/{name}/3dgs_before_final_aligned.ply'
                    info = align_ply_from_ape_log(
                        ape_log_path=f'{output_folder}/{name}/log_ape_traj_kf_beforeBA.txt',
                        ply_in=before_align_3dgs,
                        ply_out=after_align_3dgs,
                    )
                elif 'afterBA' in traj_name:
                    before_align_3dgs = f'{output_folder}/{name}/3dgs_final.ply'
                    after_align_3dgs = f'{output_folder}/{name}/3dgs_final_aligned.ply'
                    info = align_ply_from_ape_log(
                        ape_log_path=f'{output_folder}/{name}/log_ape_traj_kf_afterBA.txt',
                        ply_in=before_align_3dgs,
                        ply_out=after_align_3dgs,
                    )
        except Exception as e:
            print(e)
            pass
                
    print(excel)
    print(excel_scale)
    
    # Build LaTeX lines
    ate_line = "ATE [cm] & " + " & ".join(f"{v:.2f}" for v in ate_values) + f" & {np.mean(ate_values):.2f} \\\\"
    scale_line = "Scale error [%] & " + " & ".join(f"{v:.2f}" for v in scale_errors) + f" & {np.mean(scale_errors):.2f} \\\\"

    # Print
    print(ate_line)
    print(scale_line)
